//-----------------------------------------------------------------------
// ラーメンタイマー①
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Button.h>
#include <RPlib.h>
#include <Tone.h>

//曲データ
char *song      = "M3A:d=4,o=4,b=135:16g,16c5,16p,16b,16a,16p,16g,16p,16a,16p,16e,16p,16g";
char *sound1    = "M1A:d=4,o=5,b=120:16g,16c6,16g5,16c6,16g5,16c6";

Matrix myMatrix = Matrix(11, 13, 1);      //マトリクスLEDを使うときのオマジナイ
Button SW1      = Button(D0, LOW);        //D0に接続されたスイッチをSW1と名づける
Button SW2      = Button(D1, LOW);        //D1に接続されたスイッチをSW2と名づける
Tone tone1;

int n = 0,i = 1;

void setup(void){
    myMatrix.setBrightness(3);
    tone1.begin(D2);
}

void loop(void){
    myMatrix.putd2(0,0,0);           //マトリクスLEDに00を表示

    //時間を設定
    while(i == 1){                   //iが1の間くり返し続ける
        SW1.listen();                //SW1の状態をマイコンに聞く
        SW2.listen();                //SW2の状態をマイコンに聞く

        if(SW1.onPress()){           //もしSW1がおされたら
            ++n;                     //nに1を足す
            n = n % 100;             //100以上の数字にならないように計算(剰余演算)
            myMatrix.putd2(0,0,n);   //マトリクスLEDに2けたの数字を表示
            tone1.play(NOTE_E4,50);  //E4(ミの音)を50ミリ秒出す
        }

        if(SW2.onPress()){           //もしSW2がおされたら
            tone1.play_rtttl(sound1);
            i = 0;                   //whileのくり返しを抜ける条件を設定
        }
    }

    //時間をカウント
    while(n > 0){                    //nがカウントダウンされ0以下になるとくり返しをやめる
        myMatrix.putd2(0,0,--n);
        delay(100);
    }

    //アラーム
    tone1.play_rtttl(song);          //songという変数に入った曲を流す
    n = 0;                           //カウントを0にリセット
    i = 1;                           //whileのくり返しに入るための条件を設定
}
