//-----------------------------------------------------------------------
// LEDグラフ表示(応用)
// クワッドウエーブ
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>

Matrix myMatrix = Matrix(11, 13, 1);        //マトリクスLEDを使うときのオマジナイ

void setup(){
    myMatrix.clear();                       //マトリクスLEDの表示を消す
}

int x,y;                                    //変数intをxとyという名前で使う
int i;                                      //変数intをiという名前で使う

void loop(){
    for(i = -7; i < 7; i++){                //切片iを-7から6まで動かす
        for(x = 0; x < 8; x++){             //xを0から7の範囲にする
            y = x + i;                      //一次関数(切片i)
            //組み合わせ次第でさまざまな場所にグラフをかく
            myMatrix.write(x, y, HIGH);     //LEDを点灯
            myMatrix.write(y, x, HIGH);     //LEDを点灯
            myMatrix.write(y, 7 - x, HIGH); //LEDを点灯
            myMatrix.write(7 - y, x, HIGH); //LEDを点灯
        }
        delay(100);
        myMatrix.clear();                   //マトリクスLEDの表示を消す
    }
}
