//-----------------------------------------------------------------------
// D0をおすとコードが変更
// D1をおすと音が出る
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Button.h>
#include <RPlib.h>
#include <Tone.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Button SW1 = Button(D0, HIGH);       //D0に接続されたスイッチをSW1と名づける
Button SW2 = Button(D1, HIGH);       //D1に接続されたスイッチをSW2と名づける
Tone tone1;                          //スピーカーを使うときのオマジナイ

const int note_code[] = {
    NOTE_C4, NOTE_D4, NOTE_E4, NOTE_F4, NOTE_G4, NOTE_A4, NOTE_B4, NOTE_C5
};
const char *code[] = {
    "C4", "D4", "E4", "F4", "G4", "A4", "B4", "C5"
};

int i = 0;                              //変数intをiという名前で使う(はじめは0)

void setup(){
    myMatrix.clear();                   //マトリクスLEDの表示を消す
    myMatrix.setBrightness(3);          //マトリクスLEDの明るさを設定(0−8)
    tone1.begin(D2);                    //D2にスピーカーを接続
    myMatrix.putch45(0, 0, code[0][0]); //マトリクスLEDに文字表示をおこなう
    myMatrix.putch45(4, 0, code[0][1]); //マトリクスLEDに数字表示をおこなう
}

void loop(){

    SW1.listen();                           //SW1の状態をマイコンに聞く
    SW2.listen();                           //SW2の状態をマイコンに聞く

    if (SW1.onPress()){                     //もしSW1が押されたら
        i++;                                //変数iの値に1を足す
        i = i % 8;                          //余算を使って0-7を繰り返す
        myMatrix.putch45(0, 0, code[i][0]); //マトリクスLEDに文字表示をおこなう
        myMatrix.putch45(4, 0, code[i][1]); //マトリクスLEDに数字表示をおこなう
    }
    if (SW2.isPressed()){                   //もしSW2が押されたら
        tone1.play(note_code[i], 10);       //code[i]の音を10ミリ秒出す
    }
}
