//-----------------------------------------------------------------------
// コントローラーでスプライトを操縦
// 音付き
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを読み込む
#include <PS2X_lib.h>
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>
#include <Tone.h>

PS2X ps2x;                           //コントローラーに名前をつける
Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Tone tone1;                          //スピーカーを使うときのオマジナイ

//スプライトの指定
//幅・高さ・絵柄を2進数で指定
Sprite pattern1 = Sprite(
    3, 3,                            //パターンの行と列を設定
    B010,
    B111,
    B010
    );


int x = 0, y = 0;                    //変数intをxとyという名前で使う(はじめは0)
int vibrate;

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //コントローラーを使うときのオマジナイ
    tone1.begin(D2);                                 //D2にスピーカーを接続
}

void loop(){

    myMatrix.write(x, y, pattern1);        //座標(x,y)にpattern1を表示
    delay(50);
    //  myMatrix.write(x,y, LOW);//LEDを消灯

    ps2x.read_gamepad(false, vibrate);     //コントローラーから値を読み取る

    if (ps2x.Button(PSB_PAD_UP)){          //もし十字ボタンの上が押されたら
        y--;
        tone1.play(NOTE_E5, 10);           //E5(ミの音)を10ミリ秒出す
        myMatrix.clear();                  //マトリクスLEDの表示を消す
    }
    if (ps2x.Button(PSB_PAD_RIGHT)){       //もし十字ボタンの右が押されたら
        x++;
        tone1.play(NOTE_E6, 10);           //E6(1オクターブ上のミの音)を10ミリ秒出す
        myMatrix.clear();                  //マトリクスLEDの表示を消す
    }
    if (ps2x.Button(PSB_PAD_LEFT)){        //もし十字ボタンの左が押されたら
        x--;
        tone1.play(NOTE_E6, 10);           //E6(1オクターブ上のミの音)を10ミリ秒出す
        myMatrix.clear();                  //マトリクスLEDの表示を消す
    }
    if (ps2x.Button(PSB_PAD_DOWN)){        //もし十字ボタンの下が押されたら
        y++;
        tone1.play(NOTE_E5, 10);           //E5(ミの音)を10ミリ秒出す
        myMatrix.clear();                  //マトリクスLEDの表示を消す
    }

    if (x > 5 || x < 0 || y > 5 || y < 0){ //if文応用編（もし＋印の位置が指定範囲の外だったら）
        vibrate = 100;                     //コントローラーを振動させる
    }
    else {                                 //そうでなければ
        vibrate = 0;                       //コントローラーの振動を止める
    }

    //xとyが画面からはみ出ないように制限する(constrain)
    x = constrain(x, 0, 5);                //xの値を0から5の数字におさめる
    y = constrain(y, 0, 5);                //yの値を0から5の数字におさめる
}
