//-----------------------------------------------------------------------
// コントローラーでLEDを操作
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを読み込む
#include <PS2X_lib.h>
#include <Sprite.h>
#include <Matrix.h>

PS2X ps2x;                           //コントローラーに名前をつける
Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ

int x = 0, y = 0;

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true);        //コントローラーを使うときのオマジナイ
}

void loop(){

    myMatrix.write(constrain(x, 0, 7), constrain(y, 0, 7), HIGH);
    delay(50);
    // myMatrix.write(constrain(x,0,7), constrain(y,0,7), LOW);

    ps2x.read_gamepad();

    if (ps2x.Button(PSB_PAD_UP)) y++;
    if (ps2x.Button(PSB_PAD_RIGHT)) x++;
    if (ps2x.Button(PSB_PAD_LEFT)) x--;
    if (ps2x.Button(PSB_PAD_DOWN)) y--;
}
