//-----------------------------------------------------------------------
// マトリクスLEDを使ったコントローラーの動作確認①
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <PS2X_lib.h>
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>

PS2X ps2x;                                           //コントローラーに名前をつける
Matrix myMatrix = Matrix(11, 13, 1);                 //マトリクスLEDを使うときのオマジナイ

int vibrate = 0;                                     //変数intをvibrateという名前で使う(はじめは0)

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //コントローラーを使うときのオマジナイ
    myMatrix.clear();                                //マトリクスLEDの表示を消す
    myMatrix.setBrightness(3);                       //マトリクスLEDの明るさを設定(0−8)
}

void loop(){
    ps2x.read_gamepad(false, vibrate); //コントローラーから値を読み取る

    if (ps2x.Button(PSB_PAD_UP)){      //もし十字ボタンの上が押されたら
        myMatrix.putch(0, 0, 'A');     //”A”を表示
    }

    if (ps2x.Button(PSB_PAD_RIGHT)){   //もし十字ボタンの右が押されたら
        myMatrix.putch(0, 0, 'B');     //”B”を表示
    }

    if (ps2x.Button(PSB_PAD_DOWN)){    //もし十字ボタンの下が押されたら
        myMatrix.putch(0, 0, 'C');     //”C”を表示
    }

    if (ps2x.Button(PSB_PAD_LEFT)){    //もし十字ボタンの左が押されたら
        myMatrix.putch(0, 0, 'D');     //”D”を表示
    }

    if (ps2x.Button(PSB_GREEN)){       //もし緑ボタンが押されたら
        myMatrix.putch(0, 0, 'E');     //”E”を表示
    }

    if (ps2x.Button(PSB_RED)){         //もし赤ボタンが押されたら
        myMatrix.putch(0, 0, 'F');     //”F”を表示
    }

    if (ps2x.Button(PSB_BLUE)){        //もし青ボタンが押されたら
        myMatrix.putch(0, 0, 'G');     //”G”を表示
    }

    if (ps2x.Button(PSB_PINK)){        //もしピンクボタンが押されたら
        myMatrix.putch(0, 0, 'H');     //”H”を表示
    }

    if (ps2x.Button(PSB_L1)){          //もしL1ボタンが押されたら
        myMatrix.putch(0, 0, 'I');     //”I”を表示
    }

    if (ps2x.Button(PSB_L2)){          //もしL2ボタンが押されたら
        myMatrix.putch(0, 0, 'J');     //”J”を表示
    }

    if (ps2x.Button(PSB_R1)){          //もしR1ボタンが押されたら
        myMatrix.putch(0, 0, 'K');     //”K”を表示
    }

    if (ps2x.Button(PSB_R2)){          //もしR2ボタンが押されたら
        myMatrix.putch(0, 0, 'L');     //”L”を表示
    }

    if (ps2x.Button(PSB_R3)){          //もしR3ボタンが押されたら
        myMatrix.putch(0, 0, 'M');     //”M”を表示
    }

    if (ps2x.Button(PSB_START)){       //もしスタートボタンが押されたら
        myMatrix.putch(0, 0, 'N');     //”N”を表示
    }

    if (ps2x.Button(PSB_SELECT)){      //もしセレクトボタンが押されたら
        myMatrix.putch(0, 0, 'O');     //”O”を表示
    }

    if (ps2x.Button(PSB_L3)){          //もしL3ボタンが押されたら
        myMatrix.putch(0, 0, 'P');     //”P”を表示
    }


    delay(50);
}
