//-----------------------------------------------------------------------
// マトリクスLEDに＋字マークを表示
// タッチセンサーに反応し左右に動く
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Button.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Button SW1 = Button(D0,HIGH);        //D0に接続されたスイッチをSW1と名づける
Button SW2 = Button(D1,HIGH);        //D1に接続されたスイッチをSW2と名づける

//スプライトの指定
//幅・高さ・絵柄を2進数で指定
Sprite pattern1 = Sprite(
    3, 3,                            //パターンの行と列を設定
    B010,
    B111,
    B010
    );

void setup(){
}

int x = 0;                          //変数intをxという名前で使う(はじめは0)

void loop(){
    SW1.listen();                   //SW1の状態をマイコンに聞く
    SW2.listen();                   //SW2の状態をマイコンに聞く
    if(SW1.onPress()){              //もしSW1がおされたら
        x--;
        myMatrix.clear();           //マトリクスLEDの表示を消す
    }
    if(SW2.onPress()){              //もしSW2がおされたら
        x++;
        myMatrix.clear();           //マトリクスLEDの表示を消す
    }
    x = constrain(x,0,5);           //今はオマジナイ
    myMatrix.write(x, 0, pattern1); //座標(x,0)にパターン1を表示
}
