//-----------------------------------------------------------------------
// 明るさを操作
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>

Matrix myMatrix = Matrix(11, 13, 1);    //マトリクスLEDを使うときのオマジナイ

//スプライトの指定
//幅・高さ・絵柄を2進数で指定
Sprite pattern1 = Sprite(
    8, 8,                               //8x8のキャラクター
    B11111111,
    B10011001,
    B10100101,
    B11011011,
    B11011011,
    B10100101,
    B10011001,
    B11111111
    );
void setup(){
}

int i;                              //変数intをiという名前で使う

void loop(){
                                    //スプライトの配置
    myMatrix.write(0, 0, pattern1); //座標(0,0)にpattern1を表示
    for(i = 0; i < 9; i++){         //0(暗い)から8(明るい)まで
        myMatrix.setBrightness(i);  //マトリクスLEDの明るさを設定(iの値で変化)
        delay(100);
    }
    for(i = 8; i >= 0; i--){        //8(明るい)から0(暗い)まで
        myMatrix.setBrightness(i);  //マトリクスLEDの明るさを設定(iの値で変化)
        delay(100);
    }
}
