//-----------------------------------------------------------------------
// sound.cpp
// サウンド関係
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <Arduino.h>
#include <Tone.h>
#include "sound.h"
#include "command.h"
#include "display.h"

extern Display *getDisplay();

Tone freq1;

// ドレミファソラシドはTone.hに定義
// 順番に{ラ,シ,ド,レ,ミ,フ,ァ,ソ,ラ}={A,B,C,D,E,F,G}
// KYUUFU, HACHIBUはsound.h
// 効果音集
static int dataWin[][2] =
{
    // 1UPっぽい音
    {NOTE_G5, HACHIBU / 2},
    {NOTE_C6, HACHIBU / 2},
    {NOTE_G5, HACHIBU / 2},
    {NOTE_C6, HACHIBU / 2},
    {NOTE_G5, HACHIBU / 2},
    {NOTE_C6, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    // コインっぽい音
    {NOTE_A5, HACHIBU / 2},
    {NOTE_D7, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    // なんとなくな音
    {NOTE_A5, HACHIBU / 2},
    {NOTE_A5, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
};

static int data1[][2] =
{
    {NOTE_G5, HACHIBU / 2},
    {NOTE_C5, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    {NOTE_B5, HACHIBU / 2},
    {NOTE_A5, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    {NOTE_G5, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    {NOTE_A5, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    {NOTE_E5, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    {NOTE_G5, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
};

static int dataSW[][2] =
{
    {NOTE_C6, HACHIBU / 2},
    {NOTE_G6, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    {NOTE_F6, HACHIBU / 2},
    {NOTE_E6, HACHIBU / 2},
    {KYUUFU, HACHIBU / 2},
    {NOTE_D6, HACHIBU / 2},
    {NOTE_C7, HACHIBU / 2},
    {NOTE_G6, HACHIBU / 2},        //
    {NOTE_F6, HACHIBU / 2},
    {NOTE_E6, HACHIBU / 2},
    {NOTE_D6, HACHIBU / 2},
    {NOTE_C7, HACHIBU / 2},
    {NOTE_G6, HACHIBU / 2},
    {NOTE_F6, HACHIBU / 2},
    {NOTE_E6, HACHIBU / 2},
    {NOTE_F6, HACHIBU / 2},
    {NOTE_D6, HACHIBU / 2}
};

void SoundManager::setup(){
    freq1.begin(A5);
}

void SoundManager::init(){
    freq1.stop();
    m_step     = MAIN_STEP_INIT;
    m_stepSub  = SUB_STEP_INIT;
    m_timeStop = 0;
    m_timeSub  = 0;
}

void SoundManager::update(){
    if(m_timeStop){
        m_timeStop--;
        if(m_timeStop == 0){
            freq1.stop();
        }
    }
}

void SoundManager::exec(){
    int i;

    switch(m_step){
    case MAIN_STEP_INIT:
        break;

    case MAIN_STEP_MOVE:
        move();
        break;

    case MAIN_STEP_DEATH:
        death();
        break;

    case MAIN_STEP_WIN:
        win();
        break;

    default:
        break;
    }
}

void SoundManager::checkCommand(int cmd){
    switch(cmd){
    default:
        break;

    case COMMAND_ROBOT_LIFE_DEC:
        freq1.play(NOTE_C4);
        m_timeStop = 10;
        break;

    case COMMAND_ROBOT_SPECIAL:
        freq1.stop();
//		m_step=MAIN_STEP_DEATH;
//		m_step=MAIN_STEP_MOVE;
        break;

    case COMMAND_ROBOT_DEATH:
        setStep(MAIN_STEP_DEATH);
        break;

    // debug
    case COMMAND_ROBOT_STAMINA_MAX:
        init();
        break;

    case COMMAND_ROBOT_WINNER:
        if(getDisplay()->getMode() == 7){
            setStep(MAIN_STEP_WIN);
        }
        else if(getDisplay()->getMode() == 0){
            init();
        }
        break;
    }
}

void SoundManager::playData(int pData[][2], int numof){
    static int i = 0;

    if(m_timeSub){
        m_timeSub--;
        if(m_timeSub == 1){
            freq1.stop();
            return;
        }
        else if(m_timeSub == 0){
            i++;
            m_timeSub = pData[i][1] + 1;
        }
    }

    switch(m_stepSub){
    case SUB_STEP_INIT:
        i         = 0;
        m_timeSub = 5;
        m_stepSub = SUB_STEP_2;
        m_timeSub = pData[0][1] + 1;

    /* break throuth */
    case SUB_STEP_2:
    {
//		int numof=sizeof(pData)/(sizeof(int)*2);
        if(i >= numof){
            i         = 0;
            m_stepSub = SUB_STEP_3;
            freq1.stop();
            break;
        }

        if(pData[i][0] == KYUUFU){
            freq1.stop();
        }
        else{
            freq1.play(pData[i][0]);
        }
    }
    break;

    case SUB_STEP_3:        // END
        init();
        break;
    }

    // debug
    int val = 0;
    //	val=m_step<<4;
    //	val+=m_stepSub;
    val = m_timeSub;
    getDisplay()->setDebugValue(val);
}

void SoundManager::win(){
    int numof = sizeof( dataWin ) / ( sizeof( int ) * 2 );
    playData(dataWin, numof);
}

void SoundManager::death(){
    int numof = sizeof( data1 ) / ( sizeof( int ) * 2 );
    playData(data1, numof);
}

void SoundManager::move(){
    if(m_timeSub) m_timeSub--;

    // 繰り返しの音をずっと
    switch(m_stepSub){
    case SUB_STEP_INIT:
        m_timeSub = 5;
        m_stepSub = SUB_STEP_2;
        break;

    case SUB_STEP_2:
        freq1.play(NOTE_C4);
        if(m_timeSub == 0){
            m_stepSub = SUB_STEP_3;
            m_timeSub = 5;
        }
        break;

    case SUB_STEP_3:
        freq1.play(NOTE_E4);
        if(m_timeSub == 0){
            m_stepSub = SUB_STEP_2;
            m_timeSub = 5;
        }
        break;
    }
}
