//-----------------------------------------------------------------------
// robot.h
// ロボット関係　ヘッダー
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#ifndef _ROBOT_H_
#define _ROBOT_H_

#include <stdint.h>

//#define LIFE_MAX   (0x44)
#define LIFE_MAX   ( 9 )
#define RUNTIMER_MAX  ( 8 * 8 )
#define STAMINA_MAX  ( 8 )

class Robot
{
public:
    Robot() : m_state(STATE_INIT), m_life(LIFE_MAX), m_stamina(STAMINA_MAX), m_ll(0), m_rr(0), m_runtimer(RUNTIMER_MAX), m_step(STEP_STAY){
    }

    void setup();

public:
    typedef enum {
        STEP_INIT,
        STEP_STAY,
        STEP_WALK,
        STEP_RUN,
        STEP_DASH,
        STEP_SPECIAL
    }STEP;
    STEP m_step;
    int8_t m_stepSub;

    typedef enum {
        STATE_INIT,
        STATE_ALIVE,
        STATE_DEATH,
        STATE_FINISH
    }STATE;
    STATE m_state;

    // SENSOR
    enum {
        TOUCH2,        // A2
        TOUCH3,        // A3
        TOUCH4,        // A4
        TOUCH5,        // A5
    };
    typedef struct sensor
    {
        bool trg;      // 0->1
        bool rTrg;     // 1->0 Release Triger
        bool repeat;   // 1
    }Sensor;
    Sensor m_touch[4];
    bool getPress(int sensor){
        return m_touch[sensor].trg;
    }

    bool getRepeat(int sensor){
        return m_touch[sensor].repeat;
    }

public:
    void init(){
        m_state     = STATE_INIT;
        m_life      = LIFE_MAX;
        m_stamina   = STAMINA_MAX;
        m_rr        = 0;
        m_ll        = 0;
        m_runtimer  = RUNTIMER_MAX;
        m_step      = STEP_INIT;
        m_stayTimer = 20;
        m_spTimer   = 0;
        m_recover   = 4;
        memset(m_touch, 0, sizeof( m_touch ));
    }

    void update();        // センサー情報更新他

    int8_t exec();

    void death(){
        m_state   = STATE_DEATH;
        m_life    = 0;
        m_stamina = 0;
        m_step    = STEP_STAY;
    }

    STATE getState(){return m_state;}

    void setState(STATE s){
        m_state = s;
    }

    STEP getStep(){
        return m_step;
    }

    void setStep(STEP s){
        m_step = s;
    }

    // コマンドチェック　true: エラー false: 異常なし
    bool checkCommand(int8_t cmd);

// ai
public:
    virtual void think(){;}

// physical
public:
//	virtual void move();
    virtual void stay();

    virtual void run();

    virtual void walk();

    virtual void special();

private:
    int8_t m_life;        // hitpoint
    int8_t m_stamina;     // stamina
    int8_t m_stamina2;    // stamina2
    int8_t m_recover;
    float m_ll;
    float m_rr;

public:
    int32_t m_runtimer;
    int32_t m_stayTimer;

private:
    int32_t m_spTimer;

public:
    void setStatus(int8_t life, int8_t stamina, int8_t recover);

    int8_t getRecover(){
        return m_recover;
    }

    void setSpeedL(float l){
        m_ll = l;
    }

    void setSpeedR(float r){
        m_rr = r;
    }

    float getSpeedL(){
        return m_ll;
    }

    float getSpeedR(){
        return m_rr;
    }

    void  setStamina(int8_t s){
        if(s < STAMINA_MAX) m_stamina = s;
        else m_stamina = STAMINA_MAX;
    }

    void addStamina(){
        if(m_stamina < STAMINA_MAX) m_stamina++;
    }

    int8_t getStamina(){
        return m_stamina;
    }

    void  setLife(int8_t l){
        if(l < LIFE_MAX) m_life = l;
        else m_life = LIFE_MAX;
    }

    int8_t getLife(){
        return m_life;
    }

    void  addLife(){
        if(m_life < LIFE_MAX) m_life++;
    }

    void  decLife(){
        if(m_life > 0) m_life--;
    }

// 判定
public:
    void setSpecial();

    void spStaminaRecover();

    bool isInit(){
        return (( m_state == STATE_INIT ) ? true : false );
    }

    bool isAlive(){
        return (( m_state == STATE_ALIVE ) ? true : false );
    }

    bool isSpecial(){
        return (( m_step == STEP_SPECIAL ) ? true : false );
    }

    bool isLose(){
        return (( m_life == 0 || m_state == STATE_DEATH ) ? true : false );
    }

    bool isTired(){
        return (( m_stamina <= 4 ) ? true : false );
    }
};

#endif
