//-----------------------------------------------------------------------
// input.cpp
// 入力関係　ゲームパッド他
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include "command.h"
#include "input.h"

void InputManager::setup(){
    // ピン設定
    ps2x.config_gamepad(13, 11, 10, 12, true, true);        // ゲームパッド初期化
    init();
}

void InputManager::init(){
    m_renshaTimer  = 0;
    m_renshaValue  = 0;
    m_renshaButton = 0;
    m_vibrate      = 0;
}

void InputManager::update(){
    // パッド更新
    ps2x.read_gamepad(false, m_vibrate);

    // パッドぶるぶる設定
    if(m_vibrateTime) m_vibrateTime--;
    if(m_vibrateTime == 0)
        m_vibrate = 0;
}

void InputManager::checkCommand(int8_t cmd){
    switch(cmd){
    default:
        break;

    case COMMAND_ROBOT_LIFE_DEC:
        setVibrate();
        break;

    case COMMAND_ROBOT_DEATH:
        setVibrate(60);
        break;
    }
}

// return: buttonがnum回連射されたときにtrue
bool InputManager::isRensha(unsigned int button, int num){
    bool ret = false;

    button &= 0xffff;
    // 連射タイマー減算
    if(decRenshaTimer() == true){
        clearRenshaValue();
    }
    // ボタン判定
    if(ps2x.ButtonPressed(button)){
        // 連射タイマーが設定されたときのみ、連射値を加算
        if(getRenshaTimer()){
            addRenshaValue(button);
        }
        // 連射タイマースタート
        setRenshaTimer(button);
    }
    // 連射値numになったらtrueを返してリセット
    if(getRenshaValue() > num){
        clearRenshaValue();
        ret = true;
    }
    return ret;
}

void InputManager::setVibrate(int time){
    m_vibrate     = 255;
    m_vibrateTime = time;
}
