//-----------------------------------------------------------------------
// display.cpp
// 画面表示関係 MatrixLEDを利用する
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <Arduino.h>
//#include <Matrix.h>
#include "./Matrix.h"        // 不具合対応libraryいじらないように強引に使用しているのでマネしてはいけない
#include "command.h"
#include "display.h"
#include "robot.h"
#include "input.h"

// Matrix registers(from Matrix.cpp)
#define REG_NOOP   0x00
#define REG_DIGIT0 0x01
#define REG_DIGIT1 0x02
#define REG_DIGIT2 0x03
#define REG_DIGIT3 0x04
#define REG_DIGIT4 0x05
#define REG_DIGIT5 0x06
#define REG_DIGIT6 0x07
#define REG_DIGIT7 0x08
#define REG_DECODEMODE  0x09
#define REG_INTENSITY   0x0A
#define REG_SCANLIMIT   0x0B
#define REG_SHUTDOWN    0x0C
#define REG_DISPLAYTEST 0x0F

extern InputManager *getInput();

extern Robot *getRobot();

extern bool display_victory();

void display_clear();

void display_gage(int column, int val);

void display_countD(int num);

void display_countD2(int num);

void display_countH(int hex);

void display_lose(int timer    = 0);

void display_special(int timer = 0);

bool display_winner();

void display_blink(int t  = 0);

void display_blink2(int t = 0);

Matrix myMatrix           = Matrix(11, 13, 1); // Mat LEDディスプレイ
Matrix *getMatrix(){
    return &myMatrix;
}

Display::Display(){
    init();
    m_timer = 0;
    m_mode  = 0;
}

void Display::setup(){
    init();
}

void Display::init(){
    myMatrix.clear();
    myMatrix.setBrightness(0x02 & 0x0F);
    init2();
}

void Display::init2(){
    myMatrix.setRegister(REG_SHUTDOWN, 0x01);        // normal operation
    myMatrix.setRegister(REG_DECODEMODE, 0x00);      // pixels not integers
    myMatrix.setRegister(REG_DISPLAYTEST, 0x00);     // not in test mode
}

void Display::checkCommand(int cmd){
    switch(cmd){
    case COMMAND_DISPLAY_MODE_INIT:
        init();
        break;

    case COMMAND_DISPLAY_CLEAR:
        display_clear();
        break;

    case COMMAND_DISPLAY_MODE_UP:
        if(m_mode < 9){
            m_mode++;
            myMatrix.clear();
            myMatrix.setBrightness(0x2);
        }
        break;

    case COMMAND_DISPLAY_MODE_DOWN:
        if(m_mode > 0){
            m_mode--;
            myMatrix.clear();
            myMatrix.setBrightness(0x2);
        }
        break;

    case COMMAND_DISPLAY_CLEAR2:        // command.h
        init2();
        break;

    case COMMAND_ROBOT_WINNER:
        if(m_mode == 7){
            m_mode = 0;
            init();
        }
        else m_mode = 7;
        break;

    default:
        break;
    }
}

void Display::update(){
    // 汎用タイマー
    m_timer++;
}

void Display::exec(){
    int mode     = m_mode;
    int tmpMode  = m_mode;
    bool bBlink  = false; // 点滅させます？
    bool bBlink2 = false; // 点滅させます2？

    // 強制表示
    if(getRobot()->isInit() == true || getRobot()->m_stayTimer){
        m_mode = 0;
    }
    else if(getRobot()->isLose() == true){
        m_mode = 8;
    }
    else if(getRobot()->isSpecial() == true){
        m_mode = 9;
    }
    else if(getRobot()->isTired() == true){
        bBlink2 = true;
    }

    // 表示モード変更のときは一回クリアと明るさ調整
    if(tmpMode != m_mode) init();

    mode = m_mode;

    // 表示　メイン処理
    if(mode == 1){
        int num = ( m_timer / 0x20 ); //加算タイマー　汎用Num
        num  = getRobot()->getStep();
        num += getRobot()->getState() << 4;
        display_countH(num);          // for Debug
    }
    else if(mode == 2){
        int num = getDebugValue();
        display_countH(num);          // for Debug
    }
    else if(mode == 7){
        bBlink2 = display_winner();
    }
    else if(mode == 8){
        // 全画面使用
        display_lose();
        bBlink = true;
    }
    else if(mode == 9){
        // 全画面使用
        display_special(m_timer);
    }
    else{
        // センター数字
        int num = ( m_timer / 0x20 );                                         //加算タイマー　汎用Num
        // 画面分割使用

        if(mode == 0) num = getRobot()->getLife();                            // Release
        else if(mode == 1){
            num  = getRobot()->getStep();
            num += getRobot()->getState() << 4;
        }
        else if(mode == 2) num = getRobot()->m_runtimer;
        else if(mode == 3) num = abs(getRobot()->getSpeedL()) + abs(getRobot()->getSpeedR());
        else if(mode == 4) num = getInput()->getRenshaValue();
        else if(mode == 5) num = getInput()->ps2x.ButtonDataByte() >> 8;      //num=getRobot()->getSpeedR();
        else if(mode == 6) num = getInput()->ps2x.ButtonDataByte() & 0x00ff;  //num=getRobot()->getSpeedL();
        else if(mode == 7) num = getRobot()->getState();
        else num = mode;

        // 中央数字部分
#if 0
        display_countH(num);                                                  // for Debug
#else
        if(mode == 5 || mode == 6){
            display_countH(num);                                              // for Debug
        }
        else{
            // TODO: 2桁から1桁表示にするときに、表示残ってしまう
            if(num < 10){
                display_countD(num);                                          // for Release
            }
            else{
//				display_countH(num);// for Debug
                display_countD2(num);                                         // for Sub Release
            }
        }
#endif
        // スタミナゲージ
        num = getRobot()->getStamina();                                       // stamina
        display_gage(0, num % 9);

        // speed gage L
        num = (int)( abs(getRobot()->getSpeedL()) + 1 ) / 16;
//		num=num*6/8;
        display_gage(6, num % 9);

        // speed gage R
        num = (int)( abs(getRobot()->getSpeedR()) + 1 ) / 16;
//		num=num*6/8;
        display_gage(7, num % 9);
    }

    // 点滅(blink)
    if(bBlink) display_blink(m_timer);
    else if(bBlink2) display_blink2(m_timer);
}

//// 以下、各種表示関数

void display_clear(){
    myMatrix.clear();
}

void display_gage(int column, int val){
#if 0                                                                //ver. 1-8
    val %= 8;
    myMatrix.line(0, column, val, column, HIGH);                     // 点灯部分
    if(val + 1 < 7) myMatrix.line(val + 1, column, 7, column, LOW);  // 消灯部分
#else                                                                //ver. 0-8
    val %= 9;
    if(val >= 1) myMatrix.line(0, column, val - 1, column, HIGH);    // 点灯部分
    if(val < 8) myMatrix.line(val, column, 7, column, LOW);          // 消灯部分
#endif
}

void display_countD(int num){
    myMatrix.putch45(3, 1, num % 10 + 0x30);
}

void display_countD2(int num){
    myMatrix.putd2(1, 1, num % 100);
}

void display_countH(int hex){
//	myMatrix.puth2(1,1,hex%0x100);
}

/// 絵柄インデックス
// 0-12 顔
// 13: 豚顔
// 14: 携帯
// 15: ↑
// 16: ↓
// 17: 驚き顔
// 18: 豚正面
// 19: 豚右
// 20: 豚左
// 21: 水滴
// 22: ドクロ
// 23: 車
// 24: ヒヨコ
// 25: 家
// 26: 走る人
// 27: 顔(口が3)
// 28: パックマン
// 29: カモメ?
// 30: インベーダー1
// 31: インベーダー2

// 負けた時の表示
void display_lose(int timer){
    // 絵柄　ドクロ
    myMatrix.putch(0, 0, 22);
}

void display_special(int timer){
    int val = 0;
    // 絵柄  ぐわぐわ
    val = ( timer >> 2 & 1 ) ? 226 : 227;
    myMatrix.putch(0, 0, val);
}

// 勝どき演出表示を作ってみよう！
// ※ delay()は指定値の合計が大きな数になると挙動がおかしくなる場合があります。
// おかしくなったら戻しましょう。
bool display_winner(){
#if 1        // 授業用
    return display_victory();
#else
    switch(num){
    case 0:
        myMatrix.putch(0, 0, 0);
        delay(200);
        myMatrix.putch(0, 0, 1);
        delay(200);
        myMatrix.putch(0, 0, 2);
        delay(200);
        myMatrix.putch(0, 0, 3);
        delay(200);
        myMatrix.putch(0, 0, 4);
        delay(200);
        myMatrix.putch(0, 0, 5);
        delay(200);
        myMatrix.putch(0, 0, 6);
        delay(200);
        break;

    case 1:
        myMatrix.putch(0, 0, 23, UP);
        delay(300);
        myMatrix.putch(0, 0, 23, RIGHT);
        delay(300);
        myMatrix.putch(0, 0, 23, DOWN);
        delay(300);
        myMatrix.putch(0, 0, 23, LEFT);
        delay(300);
        break;

    case 2:
        delay(1400);
        break;

    case 3:
        break;

    case 4:
        break;
    }
    myMatrix.clear();
    return false;
#endif
}

// 点滅させる
void display_blink(int t){
    if(t & 0x10) myMatrix.setBrightness(0xF);
    else myMatrix.setBrightness(0x2);
}

// 点滅させる(早）
void display_blink2(int t){
    if(t & 0x8) myMatrix.setBrightness(0xF);
    else myMatrix.setBrightness(0x2);
}
