//-----------------------------------------------------------------------
// command.cpp
// 各種命令を作成する
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include "command.h"
#include "input.h"
#include "robot.h"

extern Robot *getRobot();

extern InputManager *getInput();

static int s_timer = 0;                   // 汎用タイマー

int8_t makeCommand(){
    int8_t cmd = COMMAND_NONE;

    s_timer++;

    if(getRobot()->isInit()) return cmd;  // 初期化中はやらない

    PS2X *ps = &getInput()->ps2x;         // 入力コントローラー抜出

    // パッド関係からコマンド作成
    // 特殊操作
    if(ps->Button(PSB_SELECT)){
        // for display
        if(ps->ButtonPressed(PSB_PAD_DOWN))
            cmd = COMMAND_DISPLAY_MODE_DOWN;

        if(ps->ButtonPressed(PSB_PAD_UP))
            cmd = COMMAND_DISPLAY_MODE_UP;

        // for robot
#if 0
        if(ps->ButtonPressed(PSB_START)){
            cmd = COMMAND_ROBOT_INIT;
        }
#endif
        if(ps->Button(PSB_START)
           && ps->Button(PSB_R1)
           && ps->Button(PSB_R2)
           && ps->Button(PSB_L1)
           && ps->Button(PSB_L2))
        {
            cmd = COMMAND_ROBOT_INIT;
        }
        if(ps->ButtonPressed(PSB_GREEN)){
            cmd = COMMAND_ROBOT_DEATH;
        }
    }
    else{
        int num = 8;

        num = 10 - getRobot()->getRecover();
        // Renshaゲージ (連射判定)
        // 連射が指定の値になった？
        if(getInput()->isRensha(PSB_RED, num)){
            cmd = COMMAND_ROBOT_STAMINA_ADD;        // スタミナ回復
        }
        if(ps->ButtonPressed(PSB_GREEN)){
            cmd = COMMAND_ROBOT_STAMINA_MAX;        // スタミナ全回復　Life-1
        }
        if(ps->ButtonPressed(PSB_BLUE)){
            cmd = COMMAND_ROBOT_SPECIAL;
        }
        if(ps->ButtonPressed(PSB_PINK)){
            cmd = COMMAND_ROBOT_WINNER;
        }
//		if(ps->ButtonPressed(PSB_PINK)){
//			getInput()->setVibrate();
//		}
    }
    // 負け判定
    if(getRobot()->isAlive() && getRobot()->isLose()){
        cmd = COMMAND_ROBOT_DEATH;
    }

    // Sensors
    if(getRobot()->isAlive()){
        if(getRobot()->getPress(Robot::TOUCH2)){
            cmd = COMMAND_ROBOT_LIFE_DEC;
        }
        if(getRobot()->getPress(Robot::TOUCH3)){
            cmd = COMMAND_ROBOT_LIFE_DEC;
        }
        if(getRobot()->getPress(Robot::TOUCH4)){
            cmd = COMMAND_ROBOT_LIFE_DEC;
        }
        if(getRobot()->getPress(Robot::TOUCH5)){
            cmd = COMMAND_ROBOT_LIFE_DEC;
        }
    }
    // 特殊処理　ディスプレイのリセットを定期的に行う(不具合暫定対応)
    if(s_timer % 20 == 0){
        cmd = COMMAND_DISPLAY_CLEAR2;
    }

    return cmd;
}

void checkCommand(int cmd){
}
