//-----------------------------------------------------------------------
// RobotBattler.ino
// ロボットバトラー　メインファイル
// ROBOPRO RobotBattler
//  written by kodachi kodachi@furo  2014/6/16
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <PS2X_lib.h>
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>
#include <stdint.h>
#include <Tone.h>
#include "input.h"
#include "Robot.h"
#include "display.h"
#include "command.h"
#include "sound.h"

namespace manager {
InputManager sInput;       // 入力管理実体
SoundManager sSound;       // サウンド管理実体
Robot sRobot;              // ロボット実体
Display sDisplay;          // ディスプレイ実体
};

// ゲッタ(推奨)
InputManager *getInput(){
    return &manager::sInput;
}                          // 入力管理インスタンス

SoundManager *getSound(){
    return &manager::sSound;
}                          // サウンド管理インスタンス

Robot *getRobot(){
    return &manager::sRobot;
}                          // ロボット

Display *getDisplay(){
    return &manager::sDisplay;
}                          // ディスプレイ

// セットアップと初期化
void setup(){
//==================================================
// 初期設定
//==================================================
    getInput()->setup();   // 入力(コントローラー)初期化
    getRobot()->setup();   // ロボット初期化
    getDisplay()->setup(); // ディスプレイ初期化
    getSound()->setup();   // サウンド初期化

// カスタマイズのポイント　その1「能力ステータスの割り振り」
// ロボットのステータスを割り振ろう!
// 合計10ポイント以内にすること!
// (ズルして11ポイント以上割り振ると、ひどいことになるよ・・・)
    getRobot()->setStatus(
        4,                 // ヒットポイント(1-8)   : 0になったら負けだ！
        3,                 // スタミナ消費スピード(1-8)   : スタミナが減りにくくなるぞ！
        3                  // スタミナ回復スピード(1-8)   : スタミナ回復が早くなるぞ！
        );
}

void loop(){
    int8_t cmd = COMMAND_NONE;

    //==================================================
    // 更新
    //==================================================
    // 入力(コントローラー)更新
    getInput()->update();
    // ロボットのセンサー更新，スピード指示更新
    getRobot()->update();
    // 画面情報更新
    getDisplay()->update();
    // サウンド更新
    getSound()->update();

    //==================================================
    // 命令作成
    //==================================================
    // 命令作成(コントローラー入力とセンサー情報から）
    cmd = makeCommand();

    //==================================================
    // 命令受け取り
    //==================================================
    // 入力(コントローラー)への命令を引き取る
    getInput()->checkCommand(cmd);
    // ロボットへの命令を引き取る
    getRobot()->checkCommand(cmd);
    // ディスプレイへの命令を引き取る
    getDisplay()->checkCommand(cmd);
    // サウンドへの命令を引き取る
    getSound()->checkCommand(cmd);

    //==================================================
    // 実行
    //==================================================
    // ロボットの計算実行
    getRobot()->exec();
    // ディスプレイの実行
    getDisplay()->exec();
    // サウンド実行
    getSound()->exec();

    // 実行周期調整
    delay(50);
}

// カスタマイズのポイント　その2「無敵時間の調整」
// 無敵時間を調整しよう！
// 無敵モードを発動して、相手に背中を向けている状態で終わると不利だぞ！
#define DEFAULT_MUTEKI_TIME  ( 100 )        // 1-100
int32_t GetDefaultMutekiTime(){
    return DEFAULT_MUTEKI_TIME;
}

// カスタマイズのポイント　その3「オリジナルの勝ちどきを上げる」
// 勝どきを上げよう！
// ※ delay()は指定値の合計が大きな数になると挙動がおかしくなる場合があります。
// おかしくなったら戻しましょう。だいたい合計1400ぐらいが限界かな・・・
bool display_victory(){
    Matrix *pMatrix = getMatrix(); // おまじない
    bool bBlink     = false;
    int num         = 1;
    // num=0;
    num = 4;                       // この数字を変更して各挙動を確認してみよう
    // ...
    switch(num){
    case 0:
        // 絵柄切り替わり
        pMatrix->putch(0, 0, 0);
        delay(200);
        pMatrix->putch(0, 0, 1);
        delay(200);
        pMatrix->putch(0, 0, 2);
        delay(200);
        pMatrix->putch(0, 0, 3);
        delay(200);
        pMatrix->putch(0, 0, 4);
        delay(200);
        pMatrix->putch(0, 0, 5);
        delay(200);
        pMatrix->putch(0, 0, 6);
        delay(200);
        break;

    case 1:
        // 回転
        pMatrix->putch(0, 0, 23, UP);
        delay(300);
        pMatrix->putch(0, 0, 23, RIGHT);
        delay(300);
        pMatrix->putch(0, 0, 23, DOWN);
        delay(300);
        pMatrix->putch(0, 0, 23, LEFT);
        delay(300);
        break;

    case 2:
        // 横スクロール
        for(int x = 0; x < 16; x++){
            pMatrix->clear();
            pMatrix->putch(x - 8, 0, 23);
            delay(80);
        }
        break;

    case 3:
        // 縦スクロール
        for(int y = 0; y < 16; y++){
            pMatrix->clear();
            pMatrix->putch(0, y - 8, 23);
            delay(80);
        }
        break;

    case 4:
        // 音,点滅を使いたいときはdelay()をつかってはいけない。
        // 音を変えたい時は、sound.cppタブをひらいてみて
        // data1とかdataSWとかをチェックしてみよう。少し難しいかな？

        // 絵柄指定
        pMatrix->putch(0, 0, 25);

        // 点滅させたい時true
        bBlink = true;
        return bBlink;
    }
    pMatrix->clear();

    return bBlink;
}

/// 絵柄インデックス
// 0-12 顔
// 13: 豚顔
// 14: 携帯
// 15: ↑
// 16: ↓
// 17: 驚き顔
// 18: 豚正面
// 19: 豚右
// 20: 豚左
// 21: 水滴
// 22: ドクロ
// 23: 車
// 24: ヒヨコ
// 25: 家
// 26: 走る人
// 27: 顔(口が3)
// 28: カニのハサミ
// 29: カモメ?
// 30: イカ
// 31: イカ２
