//-----------------------------------------------------------------------
// 触覚センサーをリンクロボットに取り付ける際に
// センサーの接続動作を確認するプログラム
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <PS2X_lib.h>

//オマジナイ
RPmotor mcl(MC1);                   //MC1に繋がっているモーターを指定する(左脚)
RPmotor mcr(MC2);                   //MC2に繋がっているモーターを指定する(右脚)

int ledPin = 13;                    //本体のLED

void setup(){
    pinMode(A2, INPUT_PULLUP);      //A2にタッチセンサーを接続
    pinMode(A3, INPUT_PULLUP);      //A3でタッチセンサーを接続
    pinMode(ledPin, OUTPUT);        //LEDを使用する
}

void loop(){
    //もし両方のセンサーが押されていれば
    if (digitalRead(A2) == HIGH && digitalRead(A3) == HIGH){
        digitalWrite(ledPin, HIGH); //LEDを点灯する
    }
    else{                           //そうでないなら
        digitalWrite(ledPin, LOW);  //LEDを消灯する
    }
    delay(10);                      //10ミリ秒待つ
}
