//-----------------------------------------------------------------------
// 触覚センサーを取り付けたリンクロボット用のプログラム
// 前進中に触覚で段差を検知すると後退して旋回する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <PS2X_lib.h>

//オマジナイ
RPmotor mcl(MC1);                   //MC1に繋がっているモーターを指定する(左脚)
RPmotor mcr(MC2);                   //MC2に繋がっているモーターを指定する(右脚)

int ledPin = 13;                    //本体のLED

void setup(){
    pinMode(A2, INPUT_PULLUP);      //A2にタッチセンサーを接続
    pinMode(A3, INPUT_PULLUP);      //A3でタッチセンサーを接続
    pinMode(ledPin, OUTPUT);        //LEDを使用する
}

void loop(){
    //もし両方のセンサーが押されていれば
    if (digitalRead(A2) == HIGH && digitalRead(A3) == HIGH){
        digitalWrite(ledPin, HIGH); //LEDを点灯して
        //----- 前に進む ---------------
        mcr.rotate(+200);           //右のモーターをプラスの向きに回転
        mcl.rotate(-200);           //左のモーターをマイナスの向きに回転
    }
    else{                           //段差があれば
        digitalWrite(ledPin, LOW);  //LEDを消灯して
        //----- 後ろに進む -------------
        mcr.rotate(-200);           //右のモーターをマイナスの向きに回転
        mcl.rotate(+200);           //左のモーターをプラスの向きに回転
        delay(1000);                //1000ミリ秒，この動きを続ける
        //----- 右に回る ---------------
        mcr.rotate(-200);           //右のモーターをマイナスの向きに回転
        mcl.rotate(-200);           //左のモーターをマイナスの向きに回転
        delay(1000);                //1000ミリ秒，この動きを続ける　　
    }
    delay(10);                      //10ミリ秒待つ
}
