//-----------------------------------------------------------------------
// リンクロボットをパターン動作させるプログラム
// チャレンジ、うずまき
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>

//おまじない
RPmotor mcl(MC2);        //MC2に繋がっているモーターを指定する(左脚)
RPmotor mcr(MC1);        //MC1に繋がっているモーターを指定する(右脚)

void setup(){
}

void loop(){
    for(int i = 200; i >= 0; i -= 2){
        mcl.rotate(-200);     //左のモーターを回転(-255～255の範囲で指定)
        mcr.rotate(i);        //右のモーターを回転(-255～255の範囲で指定)
        delay(500);
    }

    mcl.rotate(0);            //渦の中心で最終的にモーターを停止
    mcr.rotate(0);            //渦の中心で最終的にモーターを停止
    while(1);                 //プログラムの挙動を停止する
}
