//-----------------------------------------------------------------------
// リンクロボットをパターン動作させるプログラム
// 直進⇒右旋回⇒直進…の繰り返し
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>

//おまじない
RPmotor mcl(MC2);        //動かすモーターの指定(左脚のモーターをMC2につなぐ)
RPmotor mcr(MC1);        //動かすモーターの指定(右脚のモーターをMC1につなぐ)

void setup(){
}

void loop(){
    //前進
    mcl.rotate(-200);  //左脚モーターを逆方向(マイナス)に回す(範囲は-255～255)
    mcr.rotate(200);   //右脚モーターを正方向(プラス)に回す(範囲は-255～255)
    delay(1000);       //1秒(1000ミリ秒)待つ

    //左旋回
    mcl.rotate(200);   //左脚モーターを正方向(プラス)に回す(範囲は-255～255)
    mcr.rotate(200);   //右脚モーターを正方向(プラス)に回す(範囲は-255～255)
    delay(500);        //0.5秒(500ミリ秒)待つ
}
