CREATE DATABASE IF NOT EXISTS `badstoredb`;
USE `badstoredb`;
CREATE USER IF NOT EXISTS 'baduser'@'localhost' IDENTIFIED BY 'secret';
GRANT ALL PRIVILEGES ON *.* TO 'baduser'@'localhost' WITH GRANT OPTION;
FLUSH PRIVILEGES;
DROP TABLE IF EXISTS `acctdb`;
CREATE TABLE `acctdb` (
  `invnum` varchar(20) default NULL,
  `amount` float(8,2) default NULL,
  `status` varchar(10) default NULL,
  `paidon` date default NULL,
  `bankinfo` varchar(20) default NULL,
  `rma` char(1) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
INSERT INTO acctdb (invnum, amount, status, paidon, bankinfo, rma) VALUES ('MS-45921', '4976.48', 'Paid', '2024-06-12', '33011:38349873766', '0');
INSERT INTO acctdb (invnum, amount, status, paidon, bankinfo, rma) VALUES ('MS-45876', '983.93', 'Submitted', '2024-06-12', '33011:38349873766', '1');
INSERT INTO acctdb (invnum, amount, status, paidon, bankinfo, rma) VALUES ('MS-45873', '34897.21', 'Received', '2024-06-11', '78011:38334587297', '0');
DROP TABLE IF EXISTS `itemdb`;
CREATE TABLE `itemdb` (
  `itemnum` int(11) default NULL,
  `sdesc` varchar(20) default NULL,
  `ldesc` varchar(40) default NULL,
  `qty` int(11) default NULL,
  `cost` float(8,2) default NULL,
  `price` float(8,2) default NULL,
  `isnew` char(1) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1000', 'Snake Oil', 'Useless but expensive', '5', '4.35', '11.5', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1001', 'Crystal Ball', 'The finest Austrian crystal for complete', '2', '13.95', '49.95', 'N');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1002', 'Magic Hat', 'The classic magicians hat', '7', '18.45', '60', 'N');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1003', 'Magic Rabbit', 'Cute white bunny', '27', '3.5', '12.5', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1004', 'Security Appliance', 'Everybody needs one', '3', '400', '3999', 'N');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1005', 'Perfect Code', 'The rarest magic of all', '1', '5', '5000', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1006', 'Security Blanket', 'Keeps you warm and toasty', '4', '9.5', '16', 'N');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1007', 'Bag \'o Fud', 'For those who believe anything', '9', '0.5', '200', 'N');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1008', 'ROI Calculator', 'Accurate Return on Investment', '99', '2.3', '22.95', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1009', 'Planning Template', 'Business Planning Tool', '2', '6.7', '24.95', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1010', 'Security 911', 'Technical Support Agreement', '1', '99', '9999', 'N');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1011', 'Money', 'There\'s never enough', '1', '3', '90', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1012', 'Endless Cup', 'Perfect for late nights', '74', '4.56', '23.98', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1013', 'Invisibility Cloak', 'For when you just want to hide', '1', '0', '8995', 'N');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('1014', 'Disappearing Ink', 'Makes perfect signatures', '43', '8.96', '30.95', 'Y');
INSERT INTO itemdb (itemnum, sdesc, ldesc, qty, cost, price, isnew) VALUES ('9999', 'Test', 'Test Item', '0', '0', '0', 'N');
DROP TABLE IF EXISTS `orderdb`;
CREATE TABLE `orderdb` (
  `sessid` int(11) default NULL,
  `orderdate` date default NULL,
  `ordertime` time default NULL,
  `ordercost` varchar(10) default NULL,
  `orderitems` int(11) default NULL,
  `itemlist` varchar(50) default NULL,
  `accountid` varchar(30) default NULL,
  `ipaddr` varchar(20) default NULL,
  `cartpaid` char(1) default NULL,
  `ccard` varchar(16) default NULL,
  `expdate` varchar(4) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228766', '2024-06-12', '07:38:05', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.50', 'Y', '4111111111111111', '0705');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228767', '2024-06-12', '07:38:05', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.150', 'Y', '5500000000000004', '0905');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078229834', '2024-06-11', '07:38:04', '$22.95', '1', '1008', 'joe@supplier.com', '10.10.10.50', 'Y', '340000000000009', '1008');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232948', '2024-06-11', '05:33:03', '$144.93', '3', '1011,1012,1014', 'mary@spender.com', '192.168.10.70', 'Y', '30000000000004', '0506');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232048', '2024-06-11', '07:38:05', '$137.90', '3', '1008,1009,1011', 'sue@spender.com', '10.10.10.350', 'Y', '601100000004', '1006');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228766', '2024-06-12', '07:38:05', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.50', 'Y', '4111111111111111', '0705');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228767', '2024-06-10', '07:38:05', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.150', 'Y', '5500000000000004', '0905');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078229834', '2024-06-10', '-00:30:59', '$22.95', '1', '1008', 'joe@supplier.com', '10.10.10.50', 'Y', '340000000000009', '1008');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232048', '2024-06-10', '05:03:57', '$137.90', '3', '1008,1009,1011', 'mary@spender.com', '192.168.10.70', 'Y', '30000000000004', '0506');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232048', '2024-06-10', '07:38:05', '$137.90', '3', '1008,1009,1011', 'sue@spender.com', '10.10.10.350', 'Y', '6011000000000004', '1006');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228766', '2024-06-09', '07:38:05', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.50', 'Y', '4111111111111111', '0705');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228767', '2024-06-09', '07:38:05', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.150', 'Y', '5500000000000004', '0905');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078229834', '2024-06-09', '07:38:05', '$22.95', '1', '1008', 'joe@supplier.com', '10.10.10.50', 'Y', '340000000000009', '1008');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232048', '2024-06-09', '07:38:05', '$137.90', '3', '1008,1009,1011', 'mary@spender.com', '192.168.10.70', 'Y', '30000000000004', '0506');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232048', '2024-06-08', '04:32:03', '$137.90', '3', '1008,1009,1011', 'sue@spender.com', '10.10.10.350', 'Y', '6011000000000004', '1006');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228766', '2024-06-06', '00:35:57', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.50', 'Y', '4111111111111111', '0705');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078228767', '2024-06-05', '07:38:05', '$46.95', '3', '1000,1003,1008', 'joe@supplier.com', '10.10.10.150', 'Y', '5500000000000004', '0905');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078229834', '2024-05-30', '05:33:56', '$22.95', '1', '1008', 'joe@supplier.com', '10.10.10.50', 'Y', '340000000000009', '1008');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232048', '2024-05-24', '07:38:05', '$137.90', '3', '1008,1009,1011', 'mary@spender.com', '192.168.10.70', 'Y', '30000000000004', '0506');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078232388', '2024-05-24', '07:38:05', '$1137.90', '3', '1008,1009,1011', 'sue@spender.com', '10.10.10.350', 'Y', '6011000000000004', '1006');
INSERT INTO orderdb (sessid, orderdate, ordertime, ordercost, orderitems, itemlist, accountid, ipaddr, cartpaid, ccard, expdate) VALUES ('1078233380', '2024-05-08', '07:38:05', '$360.00', '1', '1002', 'fred@newuser.com', '172.22.15.47', 'Y', '201400000000009', '0705');
DROP TABLE IF EXISTS `userdb`;
CREATE TABLE `userdb` (
  `email` varchar(40) default NULL,
  `passwd` varchar(32) default NULL,
  `pwdhint` varchar(8) default NULL,
  `fullname` varchar(50) default NULL,
  `role` char(1) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('AAA_Test_User', '098F6BCD4621D373CADE4E832627B4F6', 'black', 'Test User', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('admin', '5EBE2294ECD0E0F08EAB7690D2A6EE69', 'black', 'Master System Administrator', 'A');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('joe@supplier.com', '62072d95acb588c7ee9d6fa0c6c85155', 'green', 'Joe Supplier', 'S');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('big@spender.com', '9726255eec083aa56dc0449a21b33190', 'blue', 'Big Spender', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('ray@supplier.com', '99b0e8da24e29e4ccb5d7d76e677c2ac', 'red', 'Ray Supplier', 'S');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('robert@spender.net', 'e40b34e3380d6d2b238762f0330fbd84', 'orange', 'Robert Spender', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('bill@gander.org', '5f4dcc3b5aa765d61d8327deb882cf99', 'purple', 'Bill Gander', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('steve@badstore.net', '8cb554127837a4002338c10a299289fb', 'red', 'Steve Owner', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('fred@whole.biz', '356c9ee60e9da05301adc3bd96f6b383', 'yellow', 'Fred Wholesaler', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('debbie@supplier.com', '2fbd38e6c6c4a64ef43fac3f0be7860e', 'green', 'Debby Supplier', 'S');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('mary@spender.com', '7f43c1e438dc11a93d19616549d4b701', 'blue', 'Mary Spender', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('sue@spender.com', 'ea0520bf4d3bd7b9d6ac40c3d63dd500', 'orange', 'Sue Spender', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('curt@customer.com', '0DF3DBF0EF9B6F1D49E88194D26AE243', 'green', 'Curt Wilson', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('paul@supplier.com', 'EB7D34C06CD6B561557D7EF389CDDA3C', 'red', 'Paul Rice', 'S');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('kevin@spender.com', NULL, NULL, 'Kevin Richards', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('ryan@badstore.net', '40C0BBDC4AEEAA39166825F8B477EDB4', 'purple', 'Ryan Shorter', 'A');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('stefan@supplier.com', '8E0FAA8363D8EE4D377574AEE8DD992E', 'yellow', 'Stefan Drege', 'S');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('landon@whole.biz', '29A4F8BFA56D3F970952AFC893355ABC', 'purple', 'Landon Scott', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('sam@customer.net', '5EBE2294ECD0E0F08EAB7690D2A6EE69', 'red', 'Sam Rahman', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('david@customer.org', '356779A9A1696714480F57FA3FB66D4C', 'blue', 'David Myers', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('john@customer.org', 'EEE86E9B0FE29B2D63C714B51CE54980', 'green', 'John Stiber', 'U');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('heinrich@supplier.de', '5f4dcc3b5aa765d61d8327deb882cf99', 'red', 'Heinrich Herber', 'S');
INSERT INTO userdb (email, passwd, pwdhint, fullname, role) VALUES ('tommy@customer.net', '7f43c1e438dc11a93d19616549d4b701', 'orange', 'Tom O\'Kelley', 'U');
