#define CLK_SPEED 2 // 0=12MHz, 1=24MHz, 2=48MHz

typedef unsigned char BYTE;
typedef unsigned short WORD;

__sfr __at 0xB2 OEA;
__sfr __at 0x80 IOA;
__sbit __at(0x80+0) PA0;
__sbit __at(0x80+1) PA1;

__xdata __at 0xE600 volatile BYTE CPUCS;

void sleep1msec(void)
{
  __asm
  mov dptr,#(0xFFFF-(295<<CLK_SPEED));
  loop_:
  inc dptr
  mov a,dpl
  orl a,dph
  jnz loop_
  __endasm;
}

void msleep(WORD msec)
{
  while (msec--) sleep1msec();
}

void main(void)
{
  CPUCS = (CPUCS&~0x18)|(CLK_SPEED<<3); // (b4=1,b3=0:48MHz)
  OEA |= 3; // out:PA0,PA1
  PA0 = 0; // D1 LED is on
  PA1 = 1; // D2 LED is off
  for (;;) {
    PA0 = 1 - PA0;
    PA1 = 1 - PA1;
    msleep(1000);
  }
}
