#define CLK_SPEED 2 // 0=12MHz, 1=24MHz, 2=48MHz

typedef unsigned char BYTE;
typedef unsigned short WORD;

__sfr __at 0xB2 OEA;
__sfr __at 0x80 IOA;
__sbit __at (0x80+0) PA0;
__sbit __at (0x80+1) PA1;

__xdata __at 0xE600 volatile BYTE CPUCS;
__xdata __at 0xE604 volatile BYTE FIFORESET;
__xdata __at 0xE614 volatile BYTE EP6CFG;
__xdata __at 0xE678 volatile BYTE I2CS;
__xdata __at 0xE679 volatile BYTE I2DAT;
__xdata __at 0xE67A volatile BYTE I2CTL;
__xdata __at 0xE698 volatile BYTE EP6BCH;
__xdata __at 0xE699 volatile BYTE EP6BCL;
__xdata __at 0xF800 volatile BYTE EP6FIFOBUF[1024];

BYTE read_eeprom(BYTE chip, WORD addr)
{
  BYTE dummy;

  while (I2CS & 0x40);    // wait for stop to be done
  I2CS = 0x80;            // set start condition
  I2DAT = chip;           // write control byte
  while (!(I2CS & 0x01)); // wait for done
  I2DAT = addr>>8;        // write hight address
  while (!(I2CS & 0x01)); // wait for done
  I2DAT = addr;           // write low address
  while (!(I2CS & 0x01)); // wait for done

  I2CS = 0x80;            // set start condition
  I2DAT = chip | 0x01;    // write control byte
  while (!(I2CS & 0x01)); // wait for done
  I2CS = 0x20;            // set last read condition
  dummy = I2DAT;          // read the dummy
  while (!(I2CS & 0x01)); // wait for done
  I2CS = 0x40;            // set stop bit
  return I2DAT;           // return data
}

void main(void)
{
  CPUCS = (CPUCS&~0x18)|(CLK_SPEED<<3);
  I2CTL = 0; // STOPIE=0, 400KHZ=0 (i2c bus speed 100kHz)
  EP6CFG = 0xE2;  // setup EP6 (1110 0010 TRM p.235 EPxCFG)

  #define chip 0xA2
  #define addr 0x0000
  #define size 16
  for (WORD i = 0; i < size; i++) {
    EP6FIFOBUF[i] = read_eeprom(chip, addr + i);
  }
  EP6BCH = 0;
  EP6BCL = size;
  
  for(;;);
}
