#ifndef FX2LP_H 
#define FX2LP_H

// typedef
typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

// define
#define MSB(w) ((WORD)w>>8)
#define LSB(w) ((WORD)w&0xFF)
#define b0 0x01
#define b1 0x02
#define b2 0x04
#define b3 0x08
#define b4 0x10
#define b5 0x20
#define b6 0x40
#define b7 0x80
#define NOP do{__asm \
  nop\
  __endasm;}while(0)
#define SYNCDELAY do{NOP;NOP;NOP;NOP;}while(0)

/*
 * EZ-USB(R) Technical Reference Manual
 * https://www.cypress.com/file/126446
 * pp.384-394
 * Table C-1. EZ-USB Registers and Buffers
 */

// GPIF Waveform Memories
__xdata __at 0xE400 volatile BYTE WAVEDATA;

// GENERAL CONFIGURATION
__xdata __at 0xE600 volatile BYTE CPUCS;
__xdata __at 0xE601 volatile BYTE IFCONFIG;
__xdata __at 0xE602 volatile BYTE PINFLAGSAB;
__xdata __at 0xE603 volatile BYTE PINFLAGSCD;
__xdata __at 0xE604 volatile BYTE FIFORESET;
__xdata __at 0xE605 volatile BYTE BREAKPT;
__xdata __at 0xE606 volatile BYTE BPADDRH;
__xdata __at 0xE607 volatile BYTE BPADDRL;
__xdata __at 0xE608 volatile BYTE UART230;
__xdata __at 0xE609 volatile BYTE FIFOPINPOLAR;
__xdata __at 0xE60A volatile BYTE REVID;
__xdata __at 0xE60B volatile BYTE REVCTL;

// UDMA
__xdata __at 0xE60C volatile BYTE GPIFHOLDAMOUNT;

// ENDPOINT CONFIGURATION
__xdata __at 0xE610 volatile BYTE EP1OUTCFG;
__xdata __at 0xE611 volatile BYTE EP1INCFG;
__xdata __at 0xE612 volatile BYTE EP2CFG;
__xdata __at 0xE613 volatile BYTE EP4CFG;
__xdata __at 0xE614 volatile BYTE EP6CFG;
__xdata __at 0xE615 volatile BYTE EP8CFG;
__xdata __at 0xE618 volatile BYTE EP2FIFOCFG;
__xdata __at 0xE619 volatile BYTE EP4FIFOCFG;
__xdata __at 0xE61A volatile BYTE EP6FIFOCFG;
__xdata __at 0xE61B volatile BYTE EP8FIFOCFG;
__xdata __at 0xE620 volatile BYTE EP2AUTOINLENH;
__xdata __at 0xE621 volatile BYTE EP2AUTOINLENL;
__xdata __at 0xE622 volatile BYTE EP4AUTOINLENH;
__xdata __at 0xE623 volatile BYTE EP4AUTOINLENL;
__xdata __at 0xE624 volatile BYTE EP6AUTOINLENH;
__xdata __at 0xE625 volatile BYTE EP6AUTOINLENL;
__xdata __at 0xE626 volatile BYTE EP8AUTOINLENH;
__xdata __at 0xE627 volatile BYTE EP8AUTOINLENL;
__xdata __at 0xE628 volatile BYTE ECCCFG;
__xdata __at 0xE629 volatile BYTE ECCRESET;
__xdata __at 0xE62A volatile BYTE ECC1B0;
__xdata __at 0xE62B volatile BYTE ECC1B1;
__xdata __at 0xE62C volatile BYTE ECC1B2;
__xdata __at 0xE62D volatile BYTE ECC2B0;
__xdata __at 0xE62E volatile BYTE ECC2B1;
__xdata __at 0xE62F volatile BYTE ECC2B2;
__xdata __at 0xE630 volatile BYTE EP2FIFOPFH;
__xdata __at 0xE631 volatile BYTE EP2FIFOPFL;
__xdata __at 0xE632 volatile BYTE EP4FIFOPFH;
__xdata __at 0xE633 volatile BYTE EP4FIFOPFL;
__xdata __at 0xE634 volatile BYTE EP6FIFOPFH;
__xdata __at 0xE635 volatile BYTE EP6FIFOPFL;
__xdata __at 0xE636 volatile BYTE EP8FIFOPFH;
__xdata __at 0xE637 volatile BYTE EP8FIFOPFL;
__xdata __at 0xE640 volatile BYTE EP2ISOINPKTS;
__xdata __at 0xE641 volatile BYTE EP4ISOINPKTS;
__xdata __at 0xE642 volatile BYTE EP6ISOINPKTS;
__xdata __at 0xE643 volatile BYTE EP8ISOINPKTS;
__xdata __at 0xE648 volatile BYTE INPKTEND;
__xdata __at 0xE649 volatile BYTE OUTPKTEND;

// INTERRUPTS
__xdata __at 0xE650 volatile BYTE EP2FIFOIE;
__xdata __at 0xE651 volatile BYTE EP2FIFOIRQ;
__xdata __at 0xE652 volatile BYTE EP4FIFOIE;
__xdata __at 0xE653 volatile BYTE EP4FIFOIRQ;
__xdata __at 0xE654 volatile BYTE EP6FIFOIE;
__xdata __at 0xE655 volatile BYTE EP6FIFOIRQ;
__xdata __at 0xE656 volatile BYTE EP8FIFOIE;
__xdata __at 0xE657 volatile BYTE EP8FIFOIRQ;
__xdata __at 0xE658 volatile BYTE IBNIE;
__xdata __at 0xE659 volatile BYTE IBNIRQ;
__xdata __at 0xE65A volatile BYTE NAKIE;
__xdata __at 0xE65B volatile BYTE NAKIRQ;
__xdata __at 0xE65C volatile BYTE USBIE;
__xdata __at 0xE65D volatile BYTE USBIRQ;
__xdata __at 0xE65E volatile BYTE EPIE;
__xdata __at 0xE65F volatile BYTE EPIRQ;
__xdata __at 0xE660 volatile BYTE GPIFIE;
__xdata __at 0xE661 volatile BYTE GPIFIRQ;
__xdata __at 0xE662 volatile BYTE USBERRIE;
__xdata __at 0xE663 volatile BYTE USBERRIRQ;
__xdata __at 0xE664 volatile BYTE ERRCNTLIM;
__xdata __at 0xE665 volatile BYTE CLRERRCNT;
__xdata __at 0xE666 volatile BYTE INT2IVEC;
__xdata __at 0xE667 volatile BYTE INT4IVEC;
__xdata __at 0xE668 volatile BYTE INTSETUP;

// INPUT/OUTPUT
__xdata __at 0xE670 volatile BYTE PORTACFG;
__xdata __at 0xE671 volatile BYTE PORTCCFG;
__xdata __at 0xE672 volatile BYTE PORTECFG;
__xdata __at 0xE678 volatile BYTE I2CS;
__xdata __at 0xE679 volatile BYTE I2DAT;
__xdata __at 0xE67A volatile BYTE I2CTL;
__xdata __at 0xE67B volatile BYTE XAUTODAT1;
__xdata __at 0xE67C volatile BYTE XAUTODAT2;

// UDMA CRC
__xdata __at 0xE67D volatile BYTE UDMACRCH;
__xdata __at 0xE67E volatile BYTE UDMACRCL;
__xdata __at 0xE67F volatile BYTE UDMACRCQUAL;

// USB CONTROL
__xdata __at 0xE680 volatile BYTE USBCS;
__xdata __at 0xE681 volatile BYTE SUSPEND;
__xdata __at 0xE682 volatile BYTE WAKEUPCS;
__xdata __at 0xE683 volatile BYTE TOGCTL;
__xdata __at 0xE684 volatile BYTE USBFRAMEH;
__xdata __at 0xE685 volatile BYTE USBFRAMEL;
__xdata __at 0xE686 volatile BYTE MICROFRAME;
__xdata __at 0xE687 volatile BYTE FNADDR;

// ENDPOINTS
__xdata __at 0xE68A volatile BYTE EP0BCH;
__xdata __at 0xE68B volatile BYTE EP0BCL;
__xdata __at 0xE68D volatile BYTE EP1OUTBC;
__xdata __at 0xE68F volatile BYTE EP1INBC;
__xdata __at 0xE690 volatile BYTE EP2BCH;
__xdata __at 0xE691 volatile BYTE EP2BCL;
__xdata __at 0xE694 volatile BYTE EP4BCH;
__xdata __at 0xE695 volatile BYTE EP4BCL;
__xdata __at 0xE698 volatile BYTE EP6BCH;
__xdata __at 0xE699 volatile BYTE EP6BCL;
__xdata __at 0xE69C volatile BYTE EP8BCH;
__xdata __at 0xE69D volatile BYTE EP8BCL;
__xdata __at 0xE6A0 volatile BYTE EP0CS;
__xdata __at 0xE6A1 volatile BYTE EP1OUTCS;
__xdata __at 0xE6A2 volatile BYTE EP1INCS;
__xdata __at 0xE6A3 volatile BYTE EP2CS;
__xdata __at 0xE6A4 volatile BYTE EP4CS;
__xdata __at 0xE6A5 volatile BYTE EP6CS;
__xdata __at 0xE6A6 volatile BYTE EP8CS;
__xdata __at 0xE6A7 volatile BYTE EP2FIFOFLGS;
__xdata __at 0xE6A8 volatile BYTE EP4FIFOFLGS;
__xdata __at 0xE6A9 volatile BYTE EP6FIFOFLGS;
__xdata __at 0xE6AA volatile BYTE EP8FIFOFLGS;
__xdata __at 0xE6AB volatile BYTE EP2FIFOBCH;
__xdata __at 0xE6AC volatile BYTE EP2FIFOBCL;
__xdata __at 0xE6AD volatile BYTE EP4FIFOBCH;
__xdata __at 0xE6AE volatile BYTE EP4FIFOBCL;
__xdata __at 0xE6AF volatile BYTE EP6FIFOBCH;
__xdata __at 0xE6B0 volatile BYTE EP6FIFOBCL;
__xdata __at 0xE6B1 volatile BYTE EP8FIFOBCH;
__xdata __at 0xE6B2 volatile BYTE EP8FIFOBCL;
__xdata __at 0xE6B3 volatile BYTE SUDPTRH;
__xdata __at 0xE6B4 volatile BYTE SUDPTRL;
__xdata __at 0xE6B5 volatile BYTE SUDPTRCTL;
__xdata __at 0xE6B8 volatile BYTE SETUPDAT[8];

// GPIF
__xdata __at 0xE6C0 volatile BYTE GPIFWFSELECT;
__xdata __at 0xE6C1 volatile BYTE GPIFIDLECS;
__xdata __at 0xE6C2 volatile BYTE GPIFIDLECTL;
__xdata __at 0xE6C3 volatile BYTE GPIFCTLCFG;
__xdata __at 0xE6C4 volatile BYTE GPIFADRH;
__xdata __at 0xE6C5 volatile BYTE GPIFADRL;

// FLOWSTATE
__xdata __at 0xE6C6 volatile BYTE FLOWSTATE;
__xdata __at 0xE6C7 volatile BYTE FLOWLOGIC;
__xdata __at 0xE6C8 volatile BYTE FLOWEQ0CTL;
__xdata __at 0xE6C9 volatile BYTE FLOWEQ1CTL;
__xdata __at 0xE6CA volatile BYTE FLOWHOLDOFF;
__xdata __at 0xE6CB volatile BYTE FLOWSTB;
__xdata __at 0xE6CC volatile BYTE FLOWSTBEDGE;
__xdata __at 0xE6CD volatile BYTE FLOWSTBHPERIOD;
__xdata __at 0xE6CE volatile BYTE GPIFTCB3;
__xdata __at 0xE6CF volatile BYTE GPIFTCB2;
__xdata __at 0xE6D0 volatile BYTE GPIFTCB1;
__xdata __at 0xE6D1 volatile BYTE GPIFTCB0;
__xdata __at 0xE6D2 volatile BYTE EP2GPIFFLGSEL;
__xdata __at 0xE6D3 volatile BYTE EP2GPIFPFSTOP;
__xdata __at 0xE6D4 volatile BYTE EP2GPIFTRIG;
__xdata __at 0xE6DA volatile BYTE EP4GPIFFLGSEL;
__xdata __at 0xE6DB volatile BYTE EP4GPIFPFSTOP;
__xdata __at 0xE6DC volatile BYTE EP4GPIFTRIG;
__xdata __at 0xE6E2 volatile BYTE EP6GPIFFLGSEL;
__xdata __at 0xE6E3 volatile BYTE EP6GPIFPFSTOP;
__xdata __at 0xE6E4 volatile BYTE EP6GPIFTRIG;
__xdata __at 0xE6EA volatile BYTE EP8GPIFFLGSEL;
__xdata __at 0xE6EB volatile BYTE EP8GPIFPFSTOP;
__xdata __at 0xE6EC volatile BYTE EP8GPIFTRIG;
__xdata __at 0xE6F0 volatile BYTE XGPIFSGLDATH;
__xdata __at 0xE6F1 volatile BYTE XGPIFSGLDATLX;
__xdata __at 0xE6F2 volatile BYTE XGPIFSGLDATLNOX;
__xdata __at 0xE6F3 volatile BYTE GPIFREADYCFG;
__xdata __at 0xE6F4 volatile BYTE GPIFREADYSTAT;
__xdata __at 0xE6F5 volatile BYTE GPIFABORT;

// ENDPOINT BUFFERS
__xdata __at 0xE740 volatile BYTE EP0BUF[64];
__xdata __at 0xE780 volatile BYTE EP1OUTBUF[64];
__xdata __at 0xE7C0 volatile BYTE EP1INBUF[64];
__xdata __at 0xF000 volatile BYTE EP2FIFOBUF[1024];
__xdata __at 0xF400 volatile BYTE EP4FIFOBUF[1024];
__xdata __at 0xF800 volatile BYTE EP6FIFOBUF[1024];
__xdata __at 0xFC00 volatile BYTE EP8FIFOBUF[1024];

// Special Function Registers (SFRs)
__sfr __at 0x80 IOA;
__sfr __at 0x81 SP;
__sfr __at 0x82 DPL;
__sfr __at 0x83 DPH;
__sfr __at 0x84 DPL1;
__sfr __at 0x85 DPH1;
__sfr __at 0x86 DPS;
__sfr __at 0x87 PCON;
__sfr __at 0x88 TCON;
__sfr __at 0x89 TMOD;
__sfr __at 0x8A TL0;
__sfr __at 0x8B TL1;
__sfr __at 0x8C TH0;
__sfr __at 0x8D TH1;
__sfr __at 0x8E CKCON;
__sfr __at 0x90 IOB;
__sfr __at 0x91 EXIF;
__sfr __at 0x92 MPAGE;
__sfr __at 0x98 SCON0;
__sfr __at 0x99 SBUF0;
__sfr __at 0x9A AUTOPTRH1;
__sfr __at 0x9B AUTOPTRL1;
__sfr __at 0x9D AUTOPTRH2;
__sfr __at 0x9E AUTOPTRL2;
__sfr __at 0xA0 IOC;
__sfr __at 0xA1 INT2CLR;
__sfr __at 0xA2 INT4CLR;
__sfr __at 0xA8 IE;
__sfr __at 0xAA EP2468STAT;
__sfr __at 0xAB EP24FIFOFLGS;
__sfr __at 0xAC EP68FIFOFLGS;
__sfr __at 0xAF AUTOPTRSETUP;
__sfr __at 0xB0 IOD;
__sfr __at 0xB1 IOE;
__sfr __at 0xB2 OEA;
__sfr __at 0xB3 OEB;
__sfr __at 0xB4 OEC;
__sfr __at 0xB5 OED;
__sfr __at 0xB6 OEE;
__sfr __at 0xB8 IP;
__sfr __at 0xBA EP01STAT;
__sfr __at 0xBB GPIFTRIG;
__sfr __at 0xBD GPIFSGLDATH;
__sfr __at 0xBE GPIFSGLDATLX;
__sfr __at 0xBF GPIFSGLDATLNOX;
__sfr __at 0xC0 SCON1;
__sfr __at 0xC1 SBUF1;
__sfr __at 0xC8 T2CON;
__sfr __at 0xCA RCAP2L;
__sfr __at 0xCB RCAP2H;
__sfr __at 0xCC TL2;
__sfr __at 0xCD TH2;
__sfr __at 0xD0 PSW;
__sfr __at 0xD8 EICON;
__sfr __at 0xE0 ACC;
__sfr __at 0xE8 EIE;
__sfr __at 0xF0 B;
__sfr __at 0xF8 EIP;

// special function bits
__sbit __at (0x80+0) PA0;
__sbit __at (0x80+1) PA1;
__sbit __at (0x80+2) PA2;
__sbit __at (0x80+3) PA3;
__sbit __at (0x80+4) PA4;
__sbit __at (0x80+5) PA5;
__sbit __at (0x80+6) PA6;
__sbit __at (0x80+7) PA7;
__sbit __at (0x88+0) IT0;
__sbit __at (0x88+1) IE0;
__sbit __at (0x88+2) IT1;
__sbit __at (0x88+3) IE1;
__sbit __at (0x88+4) TR0;
__sbit __at (0x88+5) TF0;
__sbit __at (0x88+6) TR1;
__sbit __at (0x88+7) TF1;
__sbit __at (0x90+0) PB0;
__sbit __at (0x90+1) PB1;
__sbit __at (0x90+2) PB2;
__sbit __at (0x90+3) PB3;
__sbit __at (0x90+4) PB4;
__sbit __at (0x90+5) PB5;
__sbit __at (0x90+6) PB6;
__sbit __at (0x90+7) PB7;
__sbit __at (0x98+0) RI;
__sbit __at (0x98+1) TI;
__sbit __at (0x98+2) RB8;
__sbit __at (0x98+3) TB8;
__sbit __at (0x98+4) REN;
__sbit __at (0x98+5) SM2;
__sbit __at (0x98+6) SM1;
__sbit __at (0x98+7) SM0;
__sbit __at (0xA0+0) PC0;
__sbit __at (0xA0+1) PC1;
__sbit __at (0xA0+2) PC2;
__sbit __at (0xA0+3) PC3;
__sbit __at (0xA0+4) PC4;
__sbit __at (0xA0+5) PC5;
__sbit __at (0xA0+6) PC6;
__sbit __at (0xA0+7) PC7;
__sbit __at (0xA8+0) EX0;
__sbit __at (0xA8+1) ET0;
__sbit __at (0xA8+2) EX1;
__sbit __at (0xA8+3) ET1;
__sbit __at (0xA8+4) ES0;
__sbit __at (0xA8+5) ET2;
__sbit __at (0xA8+6) ES1;
__sbit __at (0xA8+7) EA;
__sbit __at (0xB0+0) PD0;
__sbit __at (0xB0+1) PD1;
__sbit __at (0xB0+2) PD2;
__sbit __at (0xB0+3) PD3;
__sbit __at (0xB0+4) PD4;
__sbit __at (0xB0+5) PD5;
__sbit __at (0xB0+6) PD6;
__sbit __at (0xB0+7) PD7;
__sbit __at (0xB8+0) PX0;
__sbit __at (0xB8+1) PT0;
__sbit __at (0xB8+2) PX1;
__sbit __at (0xB8+3) PT1;
__sbit __at (0xB8+4) PS0;
__sbit __at (0xB8+5) PT2;
__sbit __at (0xB8+6) PS1;
__sbit __at (0xC0+0) RI1;
__sbit __at (0xC0+1) TI1;
__sbit __at (0xC0+2) RB81;
__sbit __at (0xC0+3) TB81;
__sbit __at (0xC0+4) REN1;
__sbit __at (0xC0+5) SM21;
__sbit __at (0xC0+6) SM11;
__sbit __at (0xC0+7) SM01;
__sbit __at (0xC8+0) CP_RL2;
__sbit __at (0xC8+1) C_T2;
__sbit __at (0xC8+2) TR2;
__sbit __at (0xC8+3) EXEN2;
__sbit __at (0xC8+4) TCLK;
__sbit __at (0xC8+5) RCLK;
__sbit __at (0xC8+6) EXF2;
__sbit __at (0xC8+7) TF2;
__sbit __at (0xD0+0) P;
__sbit __at (0xD0+1) FL;
__sbit __at (0xD0+2) OV;
__sbit __at (0xD0+3) RS0;
__sbit __at (0xD0+4) RS1;
__sbit __at (0xD0+5) F0;
__sbit __at (0xD0+6) AC;
__sbit __at (0xD0+7) CY;
__sbit __at (0xD8+3) INT6;
__sbit __at (0xD8+4) RESI;
__sbit __at (0xD8+5) ERESI;
__sbit __at (0xD8+7) SMOD1;
__sbit __at (0xE8+0) EUSB;
__sbit __at (0xE8+1) EI2C;
__sbit __at (0xE8+2) EIEX4;
__sbit __at (0xE8+3) EIEX5;
__sbit __at (0xE8+4) EIEX6;
__sbit __at (0xF8+0) PUSB;
__sbit __at (0xF8+1) PI2C;
__sbit __at (0xF8+2) EIPX4;
__sbit __at (0xF8+3) EIPX5;
__sbit __at (0xF8+4) EIPX6;

#endif
